/*
 * Decompiled with CFR 0.152.
 */
package andrews.online_detector;

import andrews.online_detector.block_entities.model.EyeModel;
import andrews.online_detector.config.ODConfigs;
import andrews.online_detector.network.ODNetwork;
import andrews.online_detector.registry.ODBlockEntities;
import andrews.online_detector.registry.ODBlocks;
import andrews.online_detector.registry.ODItems;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="online_detector")
public class OnlineDetector {
    public static OnlineDetector instance;

    public OnlineDetector() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ODItems.ITEMS.register(modEventBus);
        ODBlocks.BLOCKS.register(modEventBus);
        ODBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(EventPriority.LOWEST, this::setupClient);
            modEventBus.addListener(this::setupLayers);
        });
        modEventBus.addListener(EventPriority.LOWEST, this::setupCommon);
        ODConfigs.registerConfigs();
    }

    void setupCommon(FMLCommonSetupEvent event) {
        ODNetwork.setupMessages();
    }

    void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(ODBlockEntities::registerBlockEntityRenderers);
    }

    void setupLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(EyeModel.EYE_LAYER_LOCATION, EyeModel::createBodyLayer);
    }
}

